/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : SYNCHRONOUS UP/DOWN BCD DECADE COUNTERS
TRUTHTABLE     : 
+--------------------------------+-----------------------+
|             INPUTS             |                       |
+--------------------------------+       OPERATION       |
|  LOAD_ ENT_  ENP_   UD_   CLK  |                       |
+--------------------------------+-----------------------+
|                            _   |                       |
|   L     X     X     X    _/    |   LOAD PARRALLEL DATA |
|                            _   |                       |
|   H     L     L     H    _/    |   BINARY COUNT UP     |
|                            _   |                       |
|   H     L     L     L    _/    |   BINARY COUNT DOWN   |
|                                |                       |
|   H     H     X     X     X    |   INHIBIT COUNTING    |
|                                |                       |
|   H     X     H     X     X    |   INHIBIT COUNTING    |
+--------------------------------+-----------------------+

     NOTE : RCO_ GOES LOW AT THE TERMINAL COUNT FOR THE 
            DURATION OF ONE CLOCK PULSE

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a168 (updn, clk, a, b, c, d, enpn, ldn, entn, qd, qc, qb, qa, rcon);
	parameter size =1;
	input
		updn,
		clk,
		a,
		b,
		c,
		d,
		enpn,
		ldn,
		entn;
	output
		qd,
		qc,
		qb,
		qa,
		rcon;
    reg
        NOTIFY_REG;
    not
	  (load, ldn);
    not
	  (enp, enpn);
    not
	  (ent, entn);
    and
	  (en1, ent, ldn);
    and
	  (en2, enp, ldn);
    and
	  (en3, ent, enp, ldn);
    not  
	M168N_inst_I1 (m168n_inst_wi1, updn);
    not  
	M168N_inst_I2 (m168n_inst_wi2, entn);
    not
	M168N_inst_I3 (m168n_inst_wi3, ldn);
    nor
	M168N_inst_NO1 (m168n_inst_wno1, enpn, entn, m168n_inst_wi3);
    nor  
	M168N_inst_NO6 (rcon, m168n_inst_wa20, m168n_inst_wa21);
    and
	M168N_inst_A1 (m168n_inst_wa1, ldn, m168n_inst_qaint);
    and
	M168N_inst_A3 (m168n_inst_wa3, m168n_inst_wi3, b);
    and
	M168N_inst_A4 (m168n_inst_wa4, m168n_inst_wna1, m168n_inst_wno1, m168n_inst_wno2, m168n_inst_wna7, m168n_inst_wqnb);
    and
	M168N_inst_A5 (m168n_inst_wa5, ldn, m168n_inst_wna2, m168n_inst_qbint);
    and
	M168N_inst_A6 (m168n_inst_wa6, m168n_inst_wi3, c);
    and
	M168N_inst_A7 (m168n_inst_wa7, ldn, m168n_inst_wna3, m168n_inst_qcint);
    and
	M168N_inst_A8 (m168n_inst_wa8, m168n_inst_wno1, m168n_inst_wno2, m168n_inst_wno3, m168n_inst_wna7, m168n_inst_wna4);
    and
	M168N_inst_A9 (m168n_inst_wa9, m168n_inst_wi3, d);
    and
	M168N_inst_A10 (m168n_inst_wa10, m168n_inst_wno1, m168n_inst_wno2, m168n_inst_wno3, m168n_inst_wno4, m168n_inst_wna5);
    and
	M168N_inst_A11 (m168n_inst_wa11, ldn, m168n_inst_wna6, m168n_inst_qdint);
    and
	M168N_inst_A20 (m168n_inst_wa20, m168n_inst_wno5, m168n_inst_wno2, m168n_inst_wi2, dd_net_72);
    and
	M168N_inst_A21 (m168n_inst_wa21, dd_net_64, m168n_inst_wi2, m168n_inst_wno2, m168n_inst_wno3, m168n_inst_wno4, m168n_inst_wno5);
    nand
	M168N_inst_NA1 (m168n_inst_wna1, updn, m168n_inst_wno5);
    nand
	M168N_inst_NA2 (m168n_inst_wna2, m168n_inst_wno1, m168n_inst_wno2);
    nand
	M168N_inst_NA3 (m168n_inst_wna3, m168n_inst_wno1, m168n_inst_wno2, m168n_inst_wno3);
    nand
	M168N_inst_NA4 (m168n_inst_wna4, ldn, m168n_inst_qcint);
    nand
	M168N_inst_NA5 (m168n_inst_wna5, ldn, m168n_inst_qdint);
    nand
	M168N_inst_NA6 (m168n_inst_wna6, m168n_inst_wno1, m168n_inst_wno2);
    nand
	M168N_inst_NA7 (m168n_inst_wna7, m168n_inst_wi1, m168n_inst_wqnc, m168n_inst_wqnd);
    xor
	M168N_inst_XO1 (m168n_inst_wxo1, m168n_inst_wa1, m168n_inst_wno1);
    or
	M168N_inst_O2 (m168n_inst_wo2, m168n_inst_wa3, m168n_inst_wa4, m168n_inst_wa5);
    or
	M168N_inst_O3 (m168n_inst_wo3, m168n_inst_wa6, m168n_inst_wa7, m168n_inst_wa8);
    or
	M168N_inst_O4 (m168n_inst_wo4, m168n_inst_wa9, m168n_inst_wa10, m168n_inst_wa11);
    not  
	M168N_inst_N1 (m168n_inst_wqna, m168n_inst_qaint);
    not  
	M168N_inst_N2 (m168n_inst_wqnb, m168n_inst_qbint);
    not 
	M168N_inst_N3 (m168n_inst_wqnc, m168n_inst_qcint);
    not  
	M168N_inst_N4 (m168n_inst_wqnd, m168n_inst_qdint);
    buf 
	  (qa, m168n_inst_qaint);
    buf  
	  (qb, m168n_inst_qbint);
    buf  
	  (qc, m168n_inst_qcint);
    buf  
	  (qd, m168n_inst_qdint);
    U_AO_3
	M168N_inst_inst1_inst1 (m168n_inst_wo1, m168n_inst_wxo1, m168n_inst_wi3, a);
    U_AOI_2_2  
	M168N_inst_inst2_inst1 (m168n_inst_wno2, dd_net_68, m168n_inst_wqna, dd_net_60, dd_net_67);
    U_AOI_2_2 
	M168N_inst_inst3_inst1 (m168n_inst_wno3, dd_net_69, m168n_inst_wqnb, m168n_inst_wi1, dd_net_73);
    U_AOI_2_2  
	M168N_inst_inst4_inst1 (m168n_inst_wno4, dd_net_69, m168n_inst_wqnc, m168n_inst_wi1, dd_net_74);
    U_AOI_2_2  
	M168N_inst_inst5_inst1 (m168n_inst_wno5, dd_net_68, m168n_inst_wqnd, dd_net_60, dd_net_75);
    U_FD_P_NO  
	M168N_inst_FF1_inst1 (m168n_inst_qaint, m168n_inst_wo1, clk, NOTIFY_REG);
    U_FD_P_NO  
	M168N_inst_FF2_inst1 (m168n_inst_qbint, m168n_inst_wo2, clk, NOTIFY_REG);
    U_FD_P_NO  
	M168N_inst_FF3_inst1 (m168n_inst_qcint, m168n_inst_wo3, clk, NOTIFY_REG);
    U_FD_P_NO 
	M168N_inst_FF4_inst1 (m168n_inst_qdint, m168n_inst_wo4, clk, NOTIFY_REG);
    buf  
	  (dd_net_60, m168n_inst_wi1);
    buf 
	  (dd_net_64, m168n_inst_wi1);
    buf  
	  (dd_net_67, m168n_inst_qaint);
    buf  
	  (dd_net_68, updn);
    buf  
	  (dd_net_69, updn);
    buf  
	  (dd_net_72, updn);
    buf  
	  (dd_net_73, m168n_inst_qbint);
    buf 
	  (dd_net_74, m168n_inst_qcint);
    buf  
	  (dd_net_75, m168n_inst_qdint);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
